
/*******************************************************************************/
/*  
	This script produces Figure B1 	
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/

//________________________________________________________________
// LWFH and HPP scores
use "../Data/onet_occ_clean.dta", clear
collapse (mean) low_wfh pp (rawsum) tot_emp (first) occ_1digit [fw=tot_emp], by(occ)

//________________________________________________________________
// linearly scale 
summ pp
local ppmax = r(max)
local ppmin = r(min)
replace pp  	= (pp - `ppmin') / (`ppmax' - `ppmin') // scale to [0,1]

summ low_wfh
local wfhmax = r(max)
local wfhmin = r(min)
replace low_wfh  	= (low_wfh - `wfhmin') / (`wfhmax' - `wfhmin') // scale to [0,1]

//________________________________________________________________
// PLOT
graph drop _all
twoway ///
	(scatter low_wfh pp if occ_1digit == 1 , mc(blue)  ms(X) msize(medlarge)) ///
	(scatter low_wfh pp if occ_1digit == 2 , mc(red)  ms(D) msize(small)) ///
 	(lfitci  low_wfh pp [aw=tot_emp] , ciplot(rline) alcolor(gray) alwidth(thick) alpattern(_) clcolor(gray) clwidth(vthick)) ///
	///(lfit  low_wfh pp [aw=tot_emp] , lcolor(gray) lwidth(vthick)) ///
	, ytitle("Low work-from-home >>") xtitle("High physical-proximity >>") ///
	yline(0.167, lc(black) lp(dash) lw(vthick)) ///
	xline(0.584, lc(black) lp(dash) lw(vthick)) ///
	legend(pos("10")  cols(1) order(1 "Professional, management, tech." 2 "Services")) ///
	title("(i) Professional, management, technology; (ii) Services") ///
	xsize(2) ysize(1) nodraw name(A1) ///
    xscale(range(0 1.01)) xlabel(0.0(0.2)1.0, format(%2.1f)) ///
	yscale(range(0 1.02)  noex) ylabel(0(0.2)1.0, format(%2.1f)) 
	
twoway ///
	(scatter low_wfh pp if occ_1digit == 3 , mc(green)  ms(T) msize(small)) ///
	(scatter low_wfh pp if occ_1digit == 4 , mc(black)  ms(O) msize(small)) ///
	///(lfit  low_wfh pp [aw=tot_emp] , lcolor(gray) lwidth(vthick)) ///
 	(lfitci  low_wfh pp [aw=tot_emp] , ciplot(rline) alcolor(gray) alwidth(thick) alpattern(_) clcolor(gray) clwidth(vthick)) ///
	, ytitle("Low work-from-home >>") xtitle("High physical-proximity >>") ///
	///yline(0.167, lc(red) lp(dash) lw(thick)) xline(0.584, lc(blue) lp(dash) lw(thick)) ///
	yline(0.167, lc(black) lp(dash) lw(vthick)) ///
	xline(0.584, lc(black) lp(dash) lw(vthick)) ///
	legend(pos("10")  cols(1) order(1 "Clerical, sales" 2 "Production, operators")) ///
	title("(iii) Clerical, sales; (iv) Production, operators ") ///
	xsize(2) ysize(1) nodraw name(A2) ///
    xscale(range(0 1.01)) xlabel(0.0(0.2)1.0, format(%2.1f)) ///
	yscale(range(0 1.02)  noex) ylabel(0(0.2)1.0, format(%2.1f)) 

graph combine A1 A2, xcommon ycommon
graph export "../Figures/figb1.eps", replace
//END
